using System;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using System.Collections;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.DAL
{

	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Mike      </Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>11/12/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Data access component providing database read/write functionality for 
	///	blood unit status.
	///</summary>

	#endregion


	public class BloodUnitStatus
	{

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/11/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7507"> 
		///		<ExpectedInput>true</ExpectedInput>
		///		<ExpectedOutput>DataTable with RowVersion</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7508"> 
		///		<ExpectedInput>false</ExpectedInput>
		///		<ExpectedOutput>DataTable without RowVersion</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// spInsertBloodUnitStatus, spUpdateBloodUnitStatus
		/// </summary>
		/// <param name="isUpdate"></param>
		/// <returns></returns>
		public static DataTable GetEmptyBloodUnitStatusTableSchema(bool isUpdate)
		{
			DataTable dtBloodUnitStatus = new DataTable(TABLE.BloodUnitStatus.TableName);
	
			dtBloodUnitStatus.Columns.Add(TABLE.BloodUnitStatus.BloodUnitStatusGuid, typeof(System.Guid));
			dtBloodUnitStatus.Columns.Add(TABLE.BloodUnitStatus.UnitStatusComments, typeof(string));
			dtBloodUnitStatus.Columns.Add(TABLE.BloodUnitStatus.BiohazardousWarningIndicator, typeof(bool));
			dtBloodUnitStatus.Columns.Add(TABLE.BloodUnitStatus.QuarantineIndicator, typeof(bool));
			dtBloodUnitStatus.Columns.Add(TABLE.BloodUnit.DivisionCode, typeof(string));

			if (isUpdate)
			{
				dtBloodUnitStatus.Columns.Add(TABLE.BloodUnitStatus.UnitStatusDate, typeof(System.DateTime));
				dtBloodUnitStatus.Columns.Add(TABLE.BloodUnitStatus.DiscardCannedCommentGuid, typeof(System.Guid));
				dtBloodUnitStatus.Columns.Add(TABLE.BloodUnitStatus.QuarantineCannedCommentGuid, typeof(System.Guid));
				dtBloodUnitStatus.Columns.Add(TABLE.BloodUnitStatus.PresumedTransfusedIndicator, typeof(bool));
				dtBloodUnitStatus.Columns.Add(TABLE.BloodUnitStatus.EmergencyIssueIndicator, typeof(bool));
				dtBloodUnitStatus.Columns.Add(TABLE.BloodUnitStatus.TestingLimitIndicator, typeof(bool));
				dtBloodUnitStatus.Columns.Add(TABLE.BloodUnitStatus.RowVersion, typeof(byte[]));
			}
			else
			{
				dtBloodUnitStatus.Columns.Add(TABLE.BloodUnitStatus.BloodUnitGuid, typeof(System.Guid));
			}

			return(dtBloodUnitStatus);
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1052"> 
		///		<ExpectedInput>BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>BloodUnitStatus DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1053"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>
		///	Retrieves blood unit status for blood unit with a given GUID.
		///</summary>
		///<param name="bloodUnitGuid">Blood unit GUID</param>
		public static DataTable GetBloodUnitStatusByGuid(System.Guid bloodUnitGuid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetBloodUnitStatusByGuid.bloodunitguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetBloodUnitStatusByGuid.divisioncode, System.Data.SqlDbType.Char)
			};
			
			prms[0].Value = bloodUnitGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;

			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetBloodUnitStatusByGuid.StoredProcName, prms);
			return ds.Tables[0];
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/9/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3718"> 
		///		<ExpectedInput>Valid blood unit unique identifier</ExpectedInput>
		///		<ExpectedOutput>Data table containing previous status of unit</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3719"> 
		///		<ExpectedInput>Empty blood unit unique identifier</ExpectedInput>
		///		<ExpectedOutput>Argument Exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Static function returns the previous status of a blood unit
		/// </summary>
		/// <param name="bloodUnitGuid">Blood unit unique identifier</param>
		/// <returns>Data table containing UnitStatusCode and UnitStatusText</returns>
		public static DataTable GetPreviousBloodUnitStatusByGuid(Guid bloodUnitGuid)
		{
			if (bloodUnitGuid == Guid.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("Blood unit unique identifier").ResString);
			}
			
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetPreviousUnitStatus.bloodunitguid, System.Data.SqlDbType.UniqueIdentifier)
			};
			
			prms[0].Value = bloodUnitGuid;

			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetPreviousUnitStatus.StoredProcName, prms);

			return ds.Tables[0];
		}
	}
}